<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = [
            [
                'name' => 'Afghanistan',
                'code' => 'AF',
                'phone_code' => '+93',
                'currency' => 'AFN',
                'currency_symbol' => '؋',
                'flag' => 'flags/af.svg',
                'status' => true,
            ],
            [
                'name' => 'Albania',
                'code' => 'AL',
                'phone_code' => '+355',
                'currency' => 'ALL',
                'currency_symbol' => 'L',
                'flag' => 'flags/al.svg',
                'status' => true,
            ],
            [
                'name' => 'Algeria',
                'code' => 'DZ',
                'phone_code' => '+213',
                'currency' => 'DZD',
                'currency_symbol' => 'د.ج',
                'flag' => 'flags/dz.svg',
                'status' => true,
            ],
            [
                'name' => 'Andorra',
                'code' => 'AD',
                'phone_code' => '+376',
                'currency' => 'EUR',
                'currency_symbol' => '€',
                'flag' => 'flags/ad.svg',
                'status' => true,
            ],
            [
                'name' => 'Angola',
                'code' => 'AO',
                'phone_code' => '+244',
                'currency' => 'AOA',
                'currency_symbol' => 'Kz',
                'flag' => 'flags/ao.svg',
                'status' => true,
            ],
            [
                'name' => 'Argentina',
                'code' => 'AR',
                'phone_code' => '+54',
                'currency' => 'ARS',
                'currency_symbol' => '$',
                'flag' => 'flags/ar.svg',
                'status' => true,
            ],
            [
                'name' => 'Armenia',
                'code' => 'AM',
                'phone_code' => '+374',
                'currency' => 'AMD',
                'currency_symbol' => '֏',
                'flag' => 'flags/am.svg',
                'status' => true,
            ],
            [
                'name' => 'Australia',
                'code' => 'AU',
                'phone_code' => '+61',
                'currency' => 'AUD',
                'currency_symbol' => '$',
                'flag' => 'flags/au.svg',
                'status' => true,
            ],
            [
                'name' => 'Austria',
                'code' => 'AT',
                'phone_code' => '+43',
                'currency' => 'EUR',
                'currency_symbol' => '€',
                'flag' => 'flags/at.svg',
                'status' => true,
            ],
            [
                'name' => 'Azerbaijan',
                'code' => 'AZ',
                'phone_code' => '+994',
                'currency' => 'AZN',
                'currency_symbol' => '₼',
                'flag' => 'flags/az.svg',
                'status' => true,
            ],
            [
                'name' => 'Bahamas',
                'code' => 'BS',
                'phone_code' => '+1-242',
                'currency' => 'BSD',
                'currency_symbol' => '$',
                'flag' => 'flags/bs.svg',
                'status' => true,
            ],
            [
                'name' => 'Bahrain',
                'code' => 'BH',
                'phone_code' => '+973',
                'currency' => 'BHD',
                'currency_symbol' => '.د.ب',
                'flag' => 'flags/bh.svg',
                'status' => true,
            ],
            [
                'name' => 'Bangladesh',
                'code' => 'BD',
                'phone_code' => '+880',
                'currency' => 'BDT',
                'currency_symbol' => '৳',
                'flag' => 'flags/bd.svg',
                'status' => true,
            ],
            [
                'name' => 'Barbados',
                'code' => 'BB',
                'phone_code' => '+1-246',
                'currency' => 'BBD',
                'currency_symbol' => '$',
                'flag' => 'flags/bb.svg',
                'status' => true,
            ],
            [
                'name' => 'Belarus',
                'code' => 'BY',
                'phone_code' => '+375',
                'currency' => 'BYN',
                'currency_symbol' => 'Br',
                'flag' => 'flags/by.svg',
                'status' => true,
            ],
            [
                'name' => 'Belgium',
                'code' => 'BE',
                'phone_code' => '+32',
                'currency' => 'EUR',
                'currency_symbol' => '€',
                'flag' => 'flags/be.svg',
                'status' => true,
            ],
            [
                'name' => 'Belize',
                'code' => 'BZ',
                'phone_code' => '+501',
                'currency' => 'BZD',
                'currency_symbol' => '$',
                'flag' => 'flags/bz.svg',
                'status' => true,
            ],
            [
                'name' => 'Benin',
                'code' => 'BJ',
                'phone_code' => '+229',
                'currency' => 'XOF',
                'currency_symbol' => 'CFA',
                'flag' => 'flags/bj.svg',
                'status' => true,
            ],
            [
                'name' => 'Bhutan',
                'code' => 'BT',
                'phone_code' => '+975',
                'currency' => 'BTN',
                'currency_symbol' => 'Nu.',
                'flag' => 'flags/bt.svg',
                'status' => true,
            ],
            [
                'name' => 'Bolivia',
                'code' => 'BO',
                'phone_code' => '+591',
                'currency' => 'BOB',
                'currency_symbol' => 'Bs.',
                'flag' => 'flags/bo.svg',
                'status' => true,
            ],
            [
                'name' => 'Bosnia and Herzegovina',
                'code' => 'BA',
                'phone_code' => '+387',
                'currency' => 'BAM',
                'currency_symbol' => 'KM',
                'flag' => 'flags/ba.svg',
                'status' => true,
            ],
            [
                'name' => 'Botswana',
                'code' => 'BW',
                'phone_code' => '+267',
                'currency' => 'BWP',
                'currency_symbol' => 'P',
                'flag' => 'flags/bw.svg',
                'status' => true,
            ],
            [
                'name' => 'Brazil',
                'code' => 'BR',
                'phone_code' => '+55',
                'currency' => 'BRL',
                'currency_symbol' => 'R$',
                'flag' => 'flags/br.svg',
                'status' => true,
            ],
            [
                'name' => 'Brunei',
                'code' => 'BN',
                'phone_code' => '+673',
                'currency' => 'BND',
                'currency_symbol' => '$',
                'flag' => 'flags/bn.svg',
                'status' => true,
            ],
            [
                'name' => 'Bulgaria',
                'code' => 'BG',
                'phone_code' => '+359',
                'currency' => 'BGN',
                'currency_symbol' => 'лв',
                'flag' => 'flags/bg.svg',
                'status' => true,
            ],
            [
                'name' => 'Burkina Faso',
                'code' => 'BF',
                'phone_code' => '+226',
                'currency' => 'XOF',
                'currency_symbol' => 'CFA',
                'flag' => 'flags/bf.svg',
                'status' => true,
            ],
            [
                'name' => 'Burundi',
                'code' => 'BI',
                'phone_code' => '+257',
                'currency' => 'BIF',
                'currency_symbol' => 'FBu',
                'flag' => 'flags/bi.svg',
                'status' => true,
            ],
        ];

        foreach ($countries as $country) {
            \App\Models\Country::updateOrCreate([
                'name' => $country['name'],
                'code' => $country['code'],
            ], $country);
        }
    }
}
